"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.determineDeps = exports.init = exports.templates = exports.templatesDir = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const pkgUp = __importStar(require("pkg-up"));
const commons_1 = require("@cdktf/commons");
const sscaff_1 = require("sscaff");
const features_1 = require("cdktf/lib/features");
const cdktf_config_1 = require("./cdktf-config");
const provider_add_1 = require("./provider-add");
const readPackageJson = () => {
    const pkgPath = pkgUp.sync({ cwd: __dirname });
    if (!pkgPath) {
        throw new Error("unable to find package.json");
    }
    return JSON.parse(fs.readFileSync(pkgPath, "utf-8"));
};
const pkg = readPackageJson();
const constructsVersion = pkg.dependencies.constructs;
exports.templatesDir = path.join(__dirname, "..", "..", "templates");
const availableTemplates = fs
    .readdirSync(exports.templatesDir)
    .filter((x) => !x.startsWith("."));
exports.templates = [];
for (const template of availableTemplates) {
    exports.templates.push(template);
}
async function init({ cdktfVersion, destination, dist, projectId, projectInfo, templatePath, sendCrashReports, providers, providersForceLocal, silent, }) {
    const deps = await determineDeps(cdktfVersion, dist);
    const futureFlags = Object.entries(features_1.FUTURE_FLAGS)
        .map(([key, value]) => `    "${key}": "${value}"`)
        .join(`,\n`);
    await (0, sscaff_1.sscaff)(templatePath, destination, {
        ...deps,
        ...projectInfo,
        futureFlags,
        projectId,
        sendCrashReports,
        silent,
    });
    const cdktfConfig = cdktf_config_1.CdktfConfig.read(destination);
    let needsGet = false;
    if (providers && providers.length) {
        needsGet = await (0, provider_add_1.providerAdd)({
            providers: providers,
            language: cdktfConfig.language,
            projectDirectory: destination,
            forceLocal: providersForceLocal,
            dist,
        });
    }
    return needsGet;
}
exports.init = init;
async function determineDeps(version = pkg.version, dist) {
    // TS: cdktf-0.10.1-dev.2160938258
    // Py: cdktf-0.10.1.dev1658821493.whl
    const pythonVersion = version
        .replace(/-pre\./g, ".dev")
        .replace(/-dev\./g, ".dev");
    if (dist) {
        const ret = {
            npm_cdktf: path.resolve(dist, "js", `cdktf@${version}.jsii.tgz`),
            npm_cdktf_cli: path.resolve(dist, "js", `cdktf-cli-${version}.tgz`),
            pypi_cdktf: path.resolve(dist, "python", `cdktf-${pythonVersion}-py3-none-any.whl`),
            mvn_cdktf: path.resolve(dist, "java", `com/hashicorp/cdktf/${version}/cdktf-${version}.jar`),
            nuget_cdktf: path.resolve(dist, "dotnet", `HashiCorp.Cdktf.${version}.nupkg`),
            go_cdktf: path.resolve(dist, "go", `cdktf`),
        };
        for (const file of Object.values(ret)) {
            if (!(await fs.pathExists(file))) {
                throw commons_1.Errors.Internal(`unable to find ${file} under the "dist" directory (${dist})`, new Error(), { version });
            }
        }
        const versions = {
            cdktf_version: version,
            constructs_version: constructsVersion,
        };
        return {
            ...ret,
            ...versions,
        };
    }
    if (version === "0.0.0") {
        throw commons_1.Errors.Usage(`cannot use version 0.0.0, use --cdktf-version, --dist or CDKTF_DIST to install from a "dist" directory`);
    }
    // determine if we want a specific pinned version or a version range we take
    // a pinned version if version includes a hyphen which means it is a
    // pre-release (e.g. "0.12.0-pre.e6834d3"). otherwise, we require a caret
    // version.
    const ver = version.includes("-") ? version : `^${version}`;
    return {
        cdktf_version: version,
        constructs_version: constructsVersion,
        npm_cdktf: `cdktf@${ver}`,
        npm_cdktf_cli: `cdktf-cli@${ver}`,
        pypi_cdktf: `cdktf~=${pythonVersion}`,
        mvn_cdktf: version,
        nuget_cdktf: version,
        go_cdktf: `v${version}`,
    };
}
exports.determineDeps = determineDeps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5pdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImluaXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLDJDQUE2QjtBQUM3Qiw2Q0FBK0I7QUFDL0IsOENBQWdDO0FBQ2hDLDRDQUF3QztBQUV4QyxtQ0FBZ0M7QUFDaEMsaURBQWtEO0FBQ2xELGlEQUE2QztBQUM3QyxpREFBNkM7QUFFN0MsTUFBTSxlQUFlLEdBQUcsR0FBRyxFQUFFO0lBQzNCLE1BQU0sT0FBTyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsRUFBRSxHQUFHLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQztJQUMvQyxJQUFJLENBQUMsT0FBTyxFQUFFO1FBQ1osTUFBTSxJQUFJLEtBQUssQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO0tBQ2hEO0lBRUQsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUM7QUFDdkQsQ0FBQyxDQUFDO0FBQ0YsTUFBTSxHQUFHLEdBQUcsZUFBZSxFQUFFLENBQUM7QUFDOUIsTUFBTSxpQkFBaUIsR0FBRyxHQUFHLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQztBQTJCekMsUUFBQSxZQUFZLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxXQUFXLENBQUMsQ0FBQztBQUUxRSxNQUFNLGtCQUFrQixHQUFHLEVBQUU7S0FDMUIsV0FBVyxDQUFDLG9CQUFZLENBQUM7S0FDekIsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztBQUN4QixRQUFBLFNBQVMsR0FBYSxFQUFFLENBQUM7QUFDdEMsS0FBSyxNQUFNLFFBQVEsSUFBSSxrQkFBa0IsRUFBRTtJQUN6QyxpQkFBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztDQUMxQjtBQUVNLEtBQUssVUFBVSxJQUFJLENBQUMsRUFDekIsWUFBWSxFQUNaLFdBQVcsRUFDWCxJQUFJLEVBQ0osU0FBUyxFQUNULFdBQVcsRUFDWCxZQUFZLEVBQ1osZ0JBQWdCLEVBQ2hCLFNBQVMsRUFDVCxtQkFBbUIsRUFDbkIsTUFBTSxHQUNHO0lBQ1QsTUFBTSxJQUFJLEdBQVEsTUFBTSxhQUFhLENBQUMsWUFBWSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBRTFELE1BQU0sV0FBVyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsdUJBQVksQ0FBQztTQUM3QyxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsRUFBRSxFQUFFLENBQUMsUUFBUSxHQUFHLE9BQU8sS0FBSyxHQUFHLENBQUM7U0FDakQsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBRWYsTUFBTSxJQUFBLGVBQU0sRUFBQyxZQUFZLEVBQUUsV0FBVyxFQUFFO1FBQ3RDLEdBQUcsSUFBSTtRQUNQLEdBQUcsV0FBVztRQUNkLFdBQVc7UUFDWCxTQUFTO1FBQ1QsZ0JBQWdCO1FBQ2hCLE1BQU07S0FDUCxDQUFDLENBQUM7SUFDSCxNQUFNLFdBQVcsR0FBRywwQkFBVyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUVsRCxJQUFJLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDckIsSUFBSSxTQUFTLElBQUksU0FBUyxDQUFDLE1BQU0sRUFBRTtRQUNqQyxRQUFRLEdBQUcsTUFBTSxJQUFBLDBCQUFXLEVBQUM7WUFDM0IsU0FBUyxFQUFFLFNBQVM7WUFDcEIsUUFBUSxFQUFFLFdBQVcsQ0FBQyxRQUFRO1lBQzlCLGdCQUFnQixFQUFFLFdBQVc7WUFDN0IsVUFBVSxFQUFFLG1CQUFtQjtZQUMvQixJQUFJO1NBQ0wsQ0FBQyxDQUFDO0tBQ0o7SUFDRCxPQUFPLFFBQVEsQ0FBQztBQUNsQixDQUFDO0FBdkNELG9CQXVDQztBQVlNLEtBQUssVUFBVSxhQUFhLENBQ2pDLFVBQWtCLEdBQUcsQ0FBQyxPQUFPLEVBQzdCLElBQWE7SUFFYixrQ0FBa0M7SUFDbEMscUNBQXFDO0lBQ3JDLE1BQU0sYUFBYSxHQUFHLE9BQU87U0FDMUIsT0FBTyxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUM7U0FDMUIsT0FBTyxDQUFDLFNBQVMsRUFBRSxNQUFNLENBQUMsQ0FBQztJQUU5QixJQUFJLElBQUksRUFBRTtRQUNSLE1BQU0sR0FBRyxHQUFHO1lBQ1YsU0FBUyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxTQUFTLE9BQU8sV0FBVyxDQUFDO1lBQ2hFLGFBQWEsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsYUFBYSxPQUFPLE1BQU0sQ0FBQztZQUNuRSxVQUFVLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FDdEIsSUFBSSxFQUNKLFFBQVEsRUFDUixTQUFTLGFBQWEsbUJBQW1CLENBQzFDO1lBQ0QsU0FBUyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQ3JCLElBQUksRUFDSixNQUFNLEVBQ04sdUJBQXVCLE9BQU8sVUFBVSxPQUFPLE1BQU0sQ0FDdEQ7WUFDRCxXQUFXLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FDdkIsSUFBSSxFQUNKLFFBQVEsRUFDUixtQkFBbUIsT0FBTyxRQUFRLENBQ25DO1lBQ0QsUUFBUSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLElBQUksRUFBRSxPQUFPLENBQUM7U0FDNUMsQ0FBQztRQUVGLEtBQUssTUFBTSxJQUFJLElBQUksTUFBTSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUNyQyxJQUFJLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRTtnQkFDaEMsTUFBTSxnQkFBTSxDQUFDLFFBQVEsQ0FDbkIsa0JBQWtCLElBQUksZ0NBQWdDLElBQUksR0FBRyxFQUM3RCxJQUFJLEtBQUssRUFBRSxFQUNYLEVBQUUsT0FBTyxFQUFFLENBQ1osQ0FBQzthQUNIO1NBQ0Y7UUFFRCxNQUFNLFFBQVEsR0FBRztZQUNmLGFBQWEsRUFBRSxPQUFPO1lBQ3RCLGtCQUFrQixFQUFFLGlCQUFpQjtTQUN0QyxDQUFDO1FBRUYsT0FBTztZQUNMLEdBQUcsR0FBRztZQUNOLEdBQUcsUUFBUTtTQUNaLENBQUM7S0FDSDtJQUVELElBQUksT0FBTyxLQUFLLE9BQU8sRUFBRTtRQUN2QixNQUFNLGdCQUFNLENBQUMsS0FBSyxDQUNoQix3R0FBd0csQ0FDekcsQ0FBQztLQUNIO0lBRUQsNEVBQTRFO0lBQzVFLG9FQUFvRTtJQUNwRSx5RUFBeUU7SUFDekUsV0FBVztJQUNYLE1BQU0sR0FBRyxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxPQUFPLEVBQUUsQ0FBQztJQUU1RCxPQUFPO1FBQ0wsYUFBYSxFQUFFLE9BQU87UUFDdEIsa0JBQWtCLEVBQUUsaUJBQWlCO1FBQ3JDLFNBQVMsRUFBRSxTQUFTLEdBQUcsRUFBRTtRQUN6QixhQUFhLEVBQUUsYUFBYSxHQUFHLEVBQUU7UUFDakMsVUFBVSxFQUFFLFVBQVUsYUFBYSxFQUFFO1FBQ3JDLFNBQVMsRUFBRSxPQUFPO1FBQ2xCLFdBQVcsRUFBRSxPQUFPO1FBQ3BCLFFBQVEsRUFBRSxJQUFJLE9BQU8sRUFBRTtLQUN4QixDQUFDO0FBQ0osQ0FBQztBQTNFRCxzQ0EyRUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0ICogYXMgZnMgZnJvbSBcImZzLWV4dHJhXCI7XG5pbXBvcnQgKiBhcyBwa2dVcCBmcm9tIFwicGtnLXVwXCI7XG5pbXBvcnQgeyBFcnJvcnMgfSBmcm9tIFwiQGNka3RmL2NvbW1vbnNcIjtcblxuaW1wb3J0IHsgc3NjYWZmIH0gZnJvbSBcInNzY2FmZlwiO1xuaW1wb3J0IHsgRlVUVVJFX0ZMQUdTIH0gZnJvbSBcImNka3RmL2xpYi9mZWF0dXJlc1wiO1xuaW1wb3J0IHsgQ2RrdGZDb25maWcgfSBmcm9tIFwiLi9jZGt0Zi1jb25maWdcIjtcbmltcG9ydCB7IHByb3ZpZGVyQWRkIH0gZnJvbSBcIi4vcHJvdmlkZXItYWRkXCI7XG5cbmNvbnN0IHJlYWRQYWNrYWdlSnNvbiA9ICgpID0+IHtcbiAgY29uc3QgcGtnUGF0aCA9IHBrZ1VwLnN5bmMoeyBjd2Q6IF9fZGlybmFtZSB9KTtcbiAgaWYgKCFwa2dQYXRoKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwidW5hYmxlIHRvIGZpbmQgcGFja2FnZS5qc29uXCIpO1xuICB9XG5cbiAgcmV0dXJuIEpTT04ucGFyc2UoZnMucmVhZEZpbGVTeW5jKHBrZ1BhdGgsIFwidXRmLThcIikpO1xufTtcbmNvbnN0IHBrZyA9IHJlYWRQYWNrYWdlSnNvbigpO1xuY29uc3QgY29uc3RydWN0c1ZlcnNpb24gPSBwa2cuZGVwZW5kZW5jaWVzLmNvbnN0cnVjdHM7XG5cbmV4cG9ydCBpbnRlcmZhY2UgTG9jYWxQcm9qZWN0IHtcbiAgRGVzY3JpcHRpb246IHN0cmluZztcbiAgTmFtZTogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFJlbW90ZVByb2plY3QgZXh0ZW5kcyBMb2NhbFByb2plY3Qge1xuICBPcmdhbml6YXRpb25OYW1lOiBzdHJpbmc7XG4gIFdvcmtzcGFjZU5hbWU6IHN0cmluZztcbiAgVGVycmFmb3JtUmVtb3RlSG9zdG5hbWU6IHN0cmluZztcbn1cbmV4cG9ydCB0eXBlIFByb2plY3QgPSBMb2NhbFByb2plY3QgfCBSZW1vdGVQcm9qZWN0O1xuXG5leHBvcnQgdHlwZSBJbml0QXJncyA9IHtcbiAgY2RrdGZWZXJzaW9uPzogc3RyaW5nO1xuICBkZXN0aW5hdGlvbjogc3RyaW5nO1xuICBkaXN0Pzogc3RyaW5nO1xuICBwcm92aWRlcnM/OiBzdHJpbmdbXTtcbiAgcHJvdmlkZXJzRm9yY2VMb2NhbD86IGJvb2xlYW47XG4gIHByb2plY3RJZDogc3RyaW5nO1xuICBwcm9qZWN0SW5mbzogUHJvamVjdDtcbiAgdGVtcGxhdGVQYXRoOiBzdHJpbmc7XG4gIHNlbmRDcmFzaFJlcG9ydHM6IGJvb2xlYW47XG4gIHNpbGVudD86IGJvb2xlYW47XG59O1xuXG5leHBvcnQgY29uc3QgdGVtcGxhdGVzRGlyID0gcGF0aC5qb2luKF9fZGlybmFtZSwgXCIuLlwiLCBcIi4uXCIsIFwidGVtcGxhdGVzXCIpO1xuXG5jb25zdCBhdmFpbGFibGVUZW1wbGF0ZXMgPSBmc1xuICAucmVhZGRpclN5bmModGVtcGxhdGVzRGlyKVxuICAuZmlsdGVyKCh4KSA9PiAheC5zdGFydHNXaXRoKFwiLlwiKSk7XG5leHBvcnQgY29uc3QgdGVtcGxhdGVzOiBzdHJpbmdbXSA9IFtdO1xuZm9yIChjb25zdCB0ZW1wbGF0ZSBvZiBhdmFpbGFibGVUZW1wbGF0ZXMpIHtcbiAgdGVtcGxhdGVzLnB1c2godGVtcGxhdGUpO1xufVxuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gaW5pdCh7XG4gIGNka3RmVmVyc2lvbixcbiAgZGVzdGluYXRpb24sXG4gIGRpc3QsXG4gIHByb2plY3RJZCxcbiAgcHJvamVjdEluZm8sXG4gIHRlbXBsYXRlUGF0aCxcbiAgc2VuZENyYXNoUmVwb3J0cyxcbiAgcHJvdmlkZXJzLFxuICBwcm92aWRlcnNGb3JjZUxvY2FsLFxuICBzaWxlbnQsXG59OiBJbml0QXJncykge1xuICBjb25zdCBkZXBzOiBhbnkgPSBhd2FpdCBkZXRlcm1pbmVEZXBzKGNka3RmVmVyc2lvbiwgZGlzdCk7XG5cbiAgY29uc3QgZnV0dXJlRmxhZ3MgPSBPYmplY3QuZW50cmllcyhGVVRVUkVfRkxBR1MpXG4gICAgLm1hcCgoW2tleSwgdmFsdWVdKSA9PiBgICAgIFwiJHtrZXl9XCI6IFwiJHt2YWx1ZX1cImApXG4gICAgLmpvaW4oYCxcXG5gKTtcblxuICBhd2FpdCBzc2NhZmYodGVtcGxhdGVQYXRoLCBkZXN0aW5hdGlvbiwge1xuICAgIC4uLmRlcHMsXG4gICAgLi4ucHJvamVjdEluZm8sXG4gICAgZnV0dXJlRmxhZ3MsXG4gICAgcHJvamVjdElkLFxuICAgIHNlbmRDcmFzaFJlcG9ydHMsXG4gICAgc2lsZW50LFxuICB9KTtcbiAgY29uc3QgY2RrdGZDb25maWcgPSBDZGt0ZkNvbmZpZy5yZWFkKGRlc3RpbmF0aW9uKTtcblxuICBsZXQgbmVlZHNHZXQgPSBmYWxzZTtcbiAgaWYgKHByb3ZpZGVycyAmJiBwcm92aWRlcnMubGVuZ3RoKSB7XG4gICAgbmVlZHNHZXQgPSBhd2FpdCBwcm92aWRlckFkZCh7XG4gICAgICBwcm92aWRlcnM6IHByb3ZpZGVycyxcbiAgICAgIGxhbmd1YWdlOiBjZGt0ZkNvbmZpZy5sYW5ndWFnZSxcbiAgICAgIHByb2plY3REaXJlY3Rvcnk6IGRlc3RpbmF0aW9uLFxuICAgICAgZm9yY2VMb2NhbDogcHJvdmlkZXJzRm9yY2VMb2NhbCxcbiAgICAgIGRpc3QsXG4gICAgfSk7XG4gIH1cbiAgcmV0dXJuIG5lZWRzR2V0O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERlcHMge1xuICBucG1fY2RrdGY6IHN0cmluZztcbiAgbnBtX2Nka3RmX2NsaTogc3RyaW5nO1xuICBweXBpX2Nka3RmOiBzdHJpbmc7XG4gIG12bl9jZGt0Zjogc3RyaW5nO1xuICBudWdldF9jZGt0Zjogc3RyaW5nO1xuICBnb19jZGt0Zjogc3RyaW5nO1xuICBjZGt0Zl92ZXJzaW9uOiBzdHJpbmc7XG4gIGNvbnN0cnVjdHNfdmVyc2lvbjogc3RyaW5nO1xufVxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGRldGVybWluZURlcHMoXG4gIHZlcnNpb246IHN0cmluZyA9IHBrZy52ZXJzaW9uLFxuICBkaXN0Pzogc3RyaW5nLFxuKTogUHJvbWlzZTxEZXBzPiB7XG4gIC8vIFRTOiBjZGt0Zi0wLjEwLjEtZGV2LjIxNjA5MzgyNThcbiAgLy8gUHk6IGNka3RmLTAuMTAuMS5kZXYxNjU4ODIxNDkzLndobFxuICBjb25zdCBweXRob25WZXJzaW9uID0gdmVyc2lvblxuICAgIC5yZXBsYWNlKC8tcHJlXFwuL2csIFwiLmRldlwiKVxuICAgIC5yZXBsYWNlKC8tZGV2XFwuL2csIFwiLmRldlwiKTtcblxuICBpZiAoZGlzdCkge1xuICAgIGNvbnN0IHJldCA9IHtcbiAgICAgIG5wbV9jZGt0ZjogcGF0aC5yZXNvbHZlKGRpc3QsIFwianNcIiwgYGNka3RmQCR7dmVyc2lvbn0uanNpaS50Z3pgKSxcbiAgICAgIG5wbV9jZGt0Zl9jbGk6IHBhdGgucmVzb2x2ZShkaXN0LCBcImpzXCIsIGBjZGt0Zi1jbGktJHt2ZXJzaW9ufS50Z3pgKSxcbiAgICAgIHB5cGlfY2RrdGY6IHBhdGgucmVzb2x2ZShcbiAgICAgICAgZGlzdCxcbiAgICAgICAgXCJweXRob25cIixcbiAgICAgICAgYGNka3RmLSR7cHl0aG9uVmVyc2lvbn0tcHkzLW5vbmUtYW55LndobGAsXG4gICAgICApLFxuICAgICAgbXZuX2Nka3RmOiBwYXRoLnJlc29sdmUoXG4gICAgICAgIGRpc3QsXG4gICAgICAgIFwiamF2YVwiLFxuICAgICAgICBgY29tL2hhc2hpY29ycC9jZGt0Zi8ke3ZlcnNpb259L2Nka3RmLSR7dmVyc2lvbn0uamFyYCxcbiAgICAgICksXG4gICAgICBudWdldF9jZGt0ZjogcGF0aC5yZXNvbHZlKFxuICAgICAgICBkaXN0LFxuICAgICAgICBcImRvdG5ldFwiLFxuICAgICAgICBgSGFzaGlDb3JwLkNka3RmLiR7dmVyc2lvbn0ubnVwa2dgLFxuICAgICAgKSxcbiAgICAgIGdvX2Nka3RmOiBwYXRoLnJlc29sdmUoZGlzdCwgXCJnb1wiLCBgY2RrdGZgKSxcbiAgICB9O1xuXG4gICAgZm9yIChjb25zdCBmaWxlIG9mIE9iamVjdC52YWx1ZXMocmV0KSkge1xuICAgICAgaWYgKCEoYXdhaXQgZnMucGF0aEV4aXN0cyhmaWxlKSkpIHtcbiAgICAgICAgdGhyb3cgRXJyb3JzLkludGVybmFsKFxuICAgICAgICAgIGB1bmFibGUgdG8gZmluZCAke2ZpbGV9IHVuZGVyIHRoZSBcImRpc3RcIiBkaXJlY3RvcnkgKCR7ZGlzdH0pYCxcbiAgICAgICAgICBuZXcgRXJyb3IoKSxcbiAgICAgICAgICB7IHZlcnNpb24gfSxcbiAgICAgICAgKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBjb25zdCB2ZXJzaW9ucyA9IHtcbiAgICAgIGNka3RmX3ZlcnNpb246IHZlcnNpb24sXG4gICAgICBjb25zdHJ1Y3RzX3ZlcnNpb246IGNvbnN0cnVjdHNWZXJzaW9uLFxuICAgIH07XG5cbiAgICByZXR1cm4ge1xuICAgICAgLi4ucmV0LFxuICAgICAgLi4udmVyc2lvbnMsXG4gICAgfTtcbiAgfVxuXG4gIGlmICh2ZXJzaW9uID09PSBcIjAuMC4wXCIpIHtcbiAgICB0aHJvdyBFcnJvcnMuVXNhZ2UoXG4gICAgICBgY2Fubm90IHVzZSB2ZXJzaW9uIDAuMC4wLCB1c2UgLS1jZGt0Zi12ZXJzaW9uLCAtLWRpc3Qgb3IgQ0RLVEZfRElTVCB0byBpbnN0YWxsIGZyb20gYSBcImRpc3RcIiBkaXJlY3RvcnlgLFxuICAgICk7XG4gIH1cblxuICAvLyBkZXRlcm1pbmUgaWYgd2Ugd2FudCBhIHNwZWNpZmljIHBpbm5lZCB2ZXJzaW9uIG9yIGEgdmVyc2lvbiByYW5nZSB3ZSB0YWtlXG4gIC8vIGEgcGlubmVkIHZlcnNpb24gaWYgdmVyc2lvbiBpbmNsdWRlcyBhIGh5cGhlbiB3aGljaCBtZWFucyBpdCBpcyBhXG4gIC8vIHByZS1yZWxlYXNlIChlLmcuIFwiMC4xMi4wLXByZS5lNjgzNGQzXCIpLiBvdGhlcndpc2UsIHdlIHJlcXVpcmUgYSBjYXJldFxuICAvLyB2ZXJzaW9uLlxuICBjb25zdCB2ZXIgPSB2ZXJzaW9uLmluY2x1ZGVzKFwiLVwiKSA/IHZlcnNpb24gOiBgXiR7dmVyc2lvbn1gO1xuXG4gIHJldHVybiB7XG4gICAgY2RrdGZfdmVyc2lvbjogdmVyc2lvbixcbiAgICBjb25zdHJ1Y3RzX3ZlcnNpb246IGNvbnN0cnVjdHNWZXJzaW9uLFxuICAgIG5wbV9jZGt0ZjogYGNka3RmQCR7dmVyfWAsXG4gICAgbnBtX2Nka3RmX2NsaTogYGNka3RmLWNsaUAke3Zlcn1gLFxuICAgIHB5cGlfY2RrdGY6IGBjZGt0Zn49JHtweXRob25WZXJzaW9ufWAsXG4gICAgbXZuX2Nka3RmOiB2ZXJzaW9uLFxuICAgIG51Z2V0X2Nka3RmOiB2ZXJzaW9uLFxuICAgIGdvX2Nka3RmOiBgdiR7dmVyc2lvbn1gLFxuICB9O1xufVxuIl19