export interface LocalProject {
    Description: string;
    Name: string;
}
export interface RemoteProject extends LocalProject {
    OrganizationName: string;
    WorkspaceName: string;
    TerraformRemoteHostname: string;
}
export type Project = LocalProject | RemoteProject;
export type InitArgs = {
    cdktfVersion?: string;
    destination: string;
    dist?: string;
    providers?: string[];
    providersForceLocal?: boolean;
    projectId: string;
    projectInfo: Project;
    templatePath: string;
    sendCrashReports: boolean;
    silent?: boolean;
};
export declare const templatesDir: string;
export declare const templates: string[];
export declare function init({ cdktfVersion, destination, dist, projectId, projectInfo, templatePath, sendCrashReports, providers, providersForceLocal, silent, }: InitArgs): Promise<boolean>;
export interface Deps {
    npm_cdktf: string;
    npm_cdktf_cli: string;
    pypi_cdktf: string;
    mvn_cdktf: string;
    nuget_cdktf: string;
    go_cdktf: string;
    cdktf_version: string;
    constructs_version: string;
}
export declare function determineDeps(version?: string, dist?: string): Promise<Deps>;
//# sourceMappingURL=init.d.ts.map