"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
// This is the programmatic entrypoint that the CLI uses.
// While this is the closest we have to a programmatic API, please understand that the interfaces in this file are not stable.
// Convert is not included here since it's published independently as @cdktf/hcl2cdk.
/* eslint-disable @typescript-eslint/no-non-null-assertion */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlannedResourceAction = exports.isTerraformOutput = exports.DeployingResourceApplyState = exports.normalizeOutputPath = exports.saveOutputs = exports.watch = exports.CdktfProject = exports.runGetInDir = exports.GetStatus = exports.get = exports.templatesDir = exports.templates = exports.init = exports.CdktfStack = exports.initializErrorReporting = exports.CdktfConfig = exports.TerraformCli = exports.providerAdd = exports.getAllPrebuiltProviders = exports.ProviderConstraint = exports.DependencyManager = void 0;
var dependency_manager_1 = require("./dependencies/dependency-manager");
Object.defineProperty(exports, "DependencyManager", { enumerable: true, get: function () { return dependency_manager_1.DependencyManager; } });
Object.defineProperty(exports, "ProviderConstraint", { enumerable: true, get: function () { return dependency_manager_1.ProviderConstraint; } });
var prebuilt_providers_1 = require("./dependencies/prebuilt-providers");
Object.defineProperty(exports, "getAllPrebuiltProviders", { enumerable: true, get: function () { return prebuilt_providers_1.getAllPrebuiltProviders; } });
var provider_add_1 = require("./provider-add");
Object.defineProperty(exports, "providerAdd", { enumerable: true, get: function () { return provider_add_1.providerAdd; } });
var terraform_cli_1 = require("./models/terraform-cli");
Object.defineProperty(exports, "TerraformCli", { enumerable: true, get: function () { return terraform_cli_1.TerraformCli; } });
var cdktf_config_1 = require("./cdktf-config");
Object.defineProperty(exports, "CdktfConfig", { enumerable: true, get: function () { return cdktf_config_1.CdktfConfig; } });
var error_reporting_1 = require("./error-reporting");
Object.defineProperty(exports, "initializErrorReporting", { enumerable: true, get: function () { return error_reporting_1.initializErrorReporting; } });
var cdktf_stack_1 = require("./cdktf-stack");
Object.defineProperty(exports, "CdktfStack", { enumerable: true, get: function () { return cdktf_stack_1.CdktfStack; } });
var init_1 = require("./init");
Object.defineProperty(exports, "init", { enumerable: true, get: function () { return init_1.init; } });
Object.defineProperty(exports, "templates", { enumerable: true, get: function () { return init_1.templates; } });
Object.defineProperty(exports, "templatesDir", { enumerable: true, get: function () { return init_1.templatesDir; } });
var get_1 = require("./get");
Object.defineProperty(exports, "get", { enumerable: true, get: function () { return get_1.get; } });
Object.defineProperty(exports, "GetStatus", { enumerable: true, get: function () { return get_1.GetStatus; } });
Object.defineProperty(exports, "runGetInDir", { enumerable: true, get: function () { return get_1.runGetInDir; } });
var cdktf_project_1 = require("./cdktf-project");
Object.defineProperty(exports, "CdktfProject", { enumerable: true, get: function () { return cdktf_project_1.CdktfProject; } });
var watch_1 = require("./watch");
Object.defineProperty(exports, "watch", { enumerable: true, get: function () { return watch_1.watch; } });
var output_1 = require("./output");
Object.defineProperty(exports, "saveOutputs", { enumerable: true, get: function () { return output_1.saveOutputs; } });
Object.defineProperty(exports, "normalizeOutputPath", { enumerable: true, get: function () { return output_1.normalizeOutputPath; } });
var terraform_1 = require("./models/terraform");
Object.defineProperty(exports, "DeployingResourceApplyState", { enumerable: true, get: function () { return terraform_1.DeployingResourceApplyState; } });
Object.defineProperty(exports, "isTerraformOutput", { enumerable: true, get: function () { return terraform_1.isTerraformOutput; } });
Object.defineProperty(exports, "PlannedResourceAction", { enumerable: true, get: function () { return terraform_1.PlannedResourceAction; } });
//# sourceMappingURL=data:application/json;base64,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