import { CdktfStack } from "../cdktf-stack";
import { SynthesizedStack } from "../synth-stack";
export declare function getSingleStack(stacks: SynthesizedStack[], stackName?: string, targetAction?: string): SynthesizedStack;
export declare function getMultipleStacks(stacks: SynthesizedStack[], patterns?: string[], targetAction?: string): SynthesizedStack[];
export declare function getStackWithNoUnmetDependencies(stackExecutors: CdktfStack[]): Promise<CdktfStack | undefined>;
export declare function findAllNestedDependantStacks(stackExecutors: CdktfStack[], stackName: string, knownDependantStackNames?: Set<string>): CdktfStack[];
export declare function getStackWithNoUnmetDependants(stackExecutors: CdktfStack[]): Promise<CdktfStack | undefined>;
export declare function checkIfAllDependantsAreIncluded(stacksToRun: SynthesizedStack[], allStacks: SynthesizedStack[]): void;
/**
  Throws an error if there is a dependency that is not included
  Cycles are detected on dependency creation at synthesis time
  Running this prevents us from being in a situation where we
  have to wait for a stack to be deployed that is not included to be run
*/
export declare function checkIfAllDependenciesAreIncluded(stacksToRun: SynthesizedStack[]): void;
//# sourceMappingURL=stack-helpers.d.ts.map