"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runGetInDir = exports.get = exports.GetStatus = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const provider_generator_1 = require("@cdktf/provider-generator");
const commons_1 = require("@cdktf/commons");
const fs = __importStar(require("fs-extra"));
const commons_2 = require("@cdktf/commons");
const path = __importStar(require("path"));
const cdktf_config_1 = require("./cdktf-config");
var GetStatus;
(function (GetStatus) {
    GetStatus["STARTING"] = "starting";
    GetStatus["DOWNLOADING"] = "downloading and generating modules and providers";
    GetStatus["DONE"] = "done";
    GetStatus["ERROR"] = "error";
})(GetStatus || (exports.GetStatus = GetStatus = {}));
async function get({ constructsOptions, constraints, constraintsToGenerate, cleanDirectory, providerSchemaCachePath, onUpdate = () => undefined, reportTelemetry = async () => undefined, }) {
    commons_2.logger.debug(`Starting get with outdir ${constructsOptions.codeMakerOutput}`);
    const constructsMaker = new provider_generator_1.ConstructsMaker(constructsOptions, providerSchemaCachePath, reportTelemetry);
    if (cleanDirectory) {
        await fs.remove(constructsOptions.codeMakerOutput);
    }
    else {
        // Remove all providers that are not in the new list
        await constructsMaker.removeFoldersThatShouldNotExist(constraints);
        if (constructsOptions.targetLanguage === commons_1.Language.TYPESCRIPT) {
            // Remove all modules
            await fs.remove(path.resolve(constructsOptions.codeMakerOutput, "modules"));
        }
    }
    // Filter constraints to generate
    const toGenerate = constraintsToGenerate ||
        (await constructsMaker.filterAlreadyGenerated(constraints));
    onUpdate(GetStatus.DOWNLOADING);
    commons_2.logger.debug("Generating provider bindings");
    await constructsMaker.generate(constraints, toGenerate);
    commons_2.logger.debug("Provider bindings generated");
    if (!(await fs.pathExists(constructsOptions.codeMakerOutput))) {
        onUpdate(GetStatus.ERROR);
        commons_2.logger.debug("Failed to generate provider bindings");
    }
    else {
        onUpdate(GetStatus.DONE);
        commons_2.logger.debug("Provider bindings generated");
    }
}
exports.get = get;
async function runGetInDir(dir, clean = true) {
    const config = cdktf_config_1.CdktfConfig.read(dir);
    const constraints = [
        ...config.terraformProviders.map((c) => new commons_1.TerraformProviderConstraint(c)),
        ...config.terraformModules.map((c) => new commons_1.TerraformModuleConstraint(c)),
    ];
    await get({
        constraints,
        constructsOptions: {
            codeMakerOutput: path.resolve(dir, config.codeMakerOutput),
            targetLanguage: config.language,
            jsiiParallelism: 1,
        },
        cleanDirectory: clean,
    });
}
exports.runGetInDir = runGetInDir;
//# sourceMappingURL=data:application/json;base64,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