import { GetOptions } from "@cdktf/provider-generator";
import { TerraformModuleConstraint, TerraformProviderConstraint, TerraformDependencyConstraint } from "@cdktf/commons";
export declare enum GetStatus {
    STARTING = "starting",
    DOWNLOADING = "downloading and generating modules and providers",
    DONE = "done",
    ERROR = "error"
}
type ParsedDependencyConstraint = TerraformModuleConstraint | TerraformProviderConstraint | TerraformDependencyConstraint;
interface GetConfig {
    constraints: ParsedDependencyConstraint[];
    constraintsToGenerate?: ParsedDependencyConstraint[];
    constructsOptions: GetOptions;
    cleanDirectory?: boolean;
    providerSchemaCachePath?: string;
    onUpdate?: (payload: GetStatus) => void;
    reportTelemetry?: (telemetry: {
        targetLanguage: string;
        trackingPayload: Record<string, any>;
    }) => Promise<void>;
}
export declare function get({ constructsOptions, constraints, constraintsToGenerate, cleanDirectory, providerSchemaCachePath, onUpdate, reportTelemetry, }: GetConfig): Promise<void>;
export declare function runGetInDir(dir: string, clean?: boolean): Promise<void>;
export {};
//# sourceMappingURL=get.d.ts.map