"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEnhanceLogMessage = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const commons_1 = require("@cdktf/commons");
// escapes any special charaters used in regex
const escapeRegexSpecialChars = (str) => str.replace(/[-/\\^$*+?.()|[\]{}]/g, "\\$&");
// uses word boundary to match the whole of the tfIdentifer
const lineHasExactMatch = (line, tfIdentifier) => new RegExp(`\\b${escapeRegexSpecialChars(tfIdentifier)}\\b`).test(line);
function createEnhanceLogMessage(stack) {
    // we never want to throw, if it does not work we just do as if it did not happen
    const pathMapping = {};
    try {
        const json = JSON.parse(stack.content);
        ["data", "resource"].forEach((type) => {
            Object.entries(json[type] || {}).forEach(([resourceType, resourceInstances]) => {
                Object.entries(resourceInstances || {}).forEach(([resourceName, resource]) => {
                    // Some constructs don't have this metadata
                    if (resource["//"] &&
                        resource["//"].metadata &&
                        resource["//"].metadata.path) {
                        pathMapping[`${resourceType}.${resourceName}`] = resource["//"].metadata.path.replace(`${stack.name}/`, "");
                    }
                });
            });
        });
    }
    catch (e) {
        commons_1.logger.debug(`Could not enhance log message: ${e}`);
    }
    return (message) => {
        return message
            .split("\n")
            .map((line) => {
            const matchingEntry = Object.entries(pathMapping).find(([tfIdentifier]) => lineHasExactMatch(line, tfIdentifier));
            if (!matchingEntry) {
                return line;
            }
            const [id, cdkPath] = matchingEntry;
            return line.replace(id, `${id} (${cdkPath})`);
        })
            .join("\n");
    };
}
exports.createEnhanceLogMessage = createEnhanceLogMessage;
//# sourceMappingURL=data:application/json;base64,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