"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureException = exports.initializErrorReporting = exports.persistReportCrashReportDecision = exports.shouldReportCrash = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const Sentry = __importStar(require("@sentry/node"));
const commons_1 = require("@cdktf/commons");
const commons_2 = require("@cdktf/commons");
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const ci_info_1 = __importDefault(require("ci-info"));
function shouldReportCrash(projectPath = process.cwd()) {
    try {
        const cdktfJson = JSON.parse(fs.readFileSync(path.resolve(projectPath, "cdktf.json"), "utf8"));
        return typeof cdktfJson.sendCrashReports === "boolean"
            ? cdktfJson.sendCrashReports
            : cdktfJson.sendCrashReports === "true";
    }
    catch (e) {
        commons_2.logger.debug(`Error determining if crash reporting should be enabled, defaulting to false: ${e}`);
        return false;
    }
}
exports.shouldReportCrash = shouldReportCrash;
function persistReportCrashReportDecision(decision, projectPath = process.cwd()) {
    const cdktfJson = JSON.parse(fs.readFileSync(path.resolve(projectPath, "cdktf.json"), "utf8"));
    cdktfJson.sendCrashReports = decision;
    fs.writeFileSync(path.resolve(projectPath, "cdktf.json"), JSON.stringify(cdktfJson, null, 2));
}
exports.persistReportCrashReportDecision = persistReportCrashReportDecision;
function isPromise(p) {
    return (typeof p === "object" &&
        typeof p.then === "function" &&
        typeof p.catch === "function");
}
async function initializErrorReporting(runConsentPrompt) {
    let shouldReport = shouldReportCrash();
    const ci = ci_info_1.default.isCI ? ci_info_1.default.name || "unknown" : false;
    // We have no info yet, so we need to ask the user
    if (shouldReport === undefined && runConsentPrompt) {
        // But only if it's a user
        if (ci) {
            return;
        }
        shouldReport = await runConsentPrompt();
        persistReportCrashReportDecision(shouldReport);
    }
    if (!shouldReport) {
        commons_2.logger.debug("Error reporting disabled");
        return;
    }
    if (!process.env.SENTRY_DSN) {
        commons_2.logger.info("Error reporting disabled: SENTRY_DSN not set");
        return;
    }
    commons_2.logger.debug("Initializing error reporting");
    Sentry.init({
        autoSessionTracking: true,
        dsn: process.env.SENTRY_DSN,
        release: `cdktf-cli-${commons_1.DISPLAY_VERSION}`,
        async beforeSend(event, hint) {
            if (!hint) {
                return event;
            }
            // The promise character is not documented, but it happens
            const originalException = hint.originalException;
            let error;
            if (isPromise(originalException)) {
                originalException.catch((e) => (error = e));
                await Promise.allSettled([originalException]);
            }
            else {
                error = originalException;
            }
            const errorMessage = (error === null || error === void 0 ? void 0 : error.toString()) || "";
            if (errorMessage.includes("Usage Error")) {
                // This is a usage error, so we don't want to report it
                return null;
            }
            return event;
        },
    });
    Sentry.configureScope(function (scope) {
        scope.setUser({
            id: (0, commons_1.getUserId)(),
        });
        scope.setTag("projectId", (0, commons_1.getProjectId)());
    });
    commons_2.logger.debug("Collecting environment information for error reporting");
    (0, commons_1.collectDebugInformation)().then((debugOutput) => {
        Sentry.setContext("environment", debugOutput);
    });
}
exports.initializErrorReporting = initializErrorReporting;
function captureException({ message, type, command, context, }) {
    if (process.env.SENTRY_DSN && shouldReportCrash()) {
        Sentry.captureException(new Error(message), {
            tags: {
                context: JSON.stringify(context),
                type,
                command,
            },
        });
    }
}
exports.captureException = captureException;
//# sourceMappingURL=data:application/json;base64,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