"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.versionMatchesConstraint = exports.parseConstraint = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const semver = __importStar(require("semver"));
const commons_1 = require("@cdktf/commons");
// constraints can be prefixed with "~>", ">", "<", "=", ">=", "<=" or "!="
// no prefix means "="
function parseConstraint(constraint) {
    var _a;
    const cleaned = constraint.trim();
    const operator = (((_a = cleaned.match(/(~>|>=|<=|>|<|=|!=)/)) === null || _a === void 0 ? void 0 : _a[0]) ||
        "=");
    const version = cleaned.replace(operator, "").trim();
    return {
        operator,
        version,
    };
}
exports.parseConstraint = parseConstraint;
function versionMatchesConstraint(version, constraint) {
    // https://www.terraform.io/language/expressions/version-constraints
    // version can contain multiple constraints split by ","
    var _a, _b;
    const constraints = constraint.split(",");
    version = (_b = (_a = semver.coerce(version)) === null || _a === void 0 ? void 0 : _a.version) !== null && _b !== void 0 ? _b : version;
    // each constraint needs to be satisfied
    return constraints.every((c) => {
        var _a, _b;
        const parsed = parseConstraint(c);
        const cleanedParsedVersion = (_b = (_a = semver.coerce(parsed.version)) === null || _a === void 0 ? void 0 : _a.version) !== null && _b !== void 0 ? _b : parsed.version;
        switch (parsed.operator) {
            case "=":
                return version === cleanedParsedVersion;
            case "!=":
                return version !== cleanedParsedVersion;
            case "~>": {
                // allows rightmost version component to increment
                const parts = parsed.version.split(".");
                const minorSpecified = parts.length === 2;
                const majorIsZero = parts[0] === "0";
                // ~>2.0 which allows 2.1 and 2.1.1 needs special handling as
                // npm semver handles "~" differently for ~2.0 than for ~2 or ~2.1.0
                // So we need to use "^" (e.g. ^2.0) for this case
                // see: https://github.com/npm/node-semver/issues/11
                const allowMinorAndPatchOnly = minorSpecified;
                let range = allowMinorAndPatchOnly
                    ? `^${parsed.version}`
                    : `~${parsed.version}`;
                // versions below 1.0 are treated a bit differently in NPM than in Terraform
                // meaning that NPMs ^0.4 doesn't allow 0.55 while TFs ~>0.4 allows 0.55
                if (majorIsZero && minorSpecified) {
                    range = `>=${parsed.version} <1.0.0`;
                }
                return semver.satisfies(version, range);
            }
            case ">=":
                return semver.gte(version, cleanedParsedVersion);
            case "<=":
                return semver.lte(version, cleanedParsedVersion);
            case ">":
                return semver.gt(version, cleanedParsedVersion);
            case "<":
                return semver.lt(version, cleanedParsedVersion);
            default:
                throw commons_1.Errors.External(`Unknown constraint operator: ${parsed.operator} in version constraint ${constraint}`);
        }
    });
}
exports.versionMatchesConstraint = versionMatchesConstraint;
//# sourceMappingURL=data:application/json;base64,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