"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLatestVersion = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const node_fetch_1 = __importDefault(require("node-fetch"));
const https_proxy_agent_1 = require("https-proxy-agent");
const semver = __importStar(require("semver"));
const commons_1 = require("@cdktf/commons");
async function fetchVersions(constraint) {
    const proxy = process.env.http_proxy || process.env.HTTP_PROXY;
    let agent;
    if (proxy) {
        agent = new https_proxy_agent_1.HttpsProxyAgent(proxy);
    }
    const url = `https://registry.terraform.io/v1/providers/${constraint.namespace}/${constraint.name}/versions`;
    const result = await (0, node_fetch_1.default)(url, {
        agent,
        headers: { "User-Agent": "HashiCorp/cdktf-cli" },
    });
    if (!result.ok) {
        if (result.status !== 404) {
            throw commons_1.Errors.External(`Failed to fetch ${url}. Status: ${result.status}`);
        }
        return null;
    }
    const json = (await result.json());
    return json.versions;
}
/**
 * returns the latest available version for the provider in the constraint
 * the version of the constraint is ignored
 * returns null, if the provider does not exist
 */
async function getLatestVersion(constraint) {
    const versions = await fetchVersions(constraint);
    if (!versions) {
        return null;
    }
    const latestVersion = versions
        .map((v) => v.version)
        .reduce((acc, curr) => {
        if (semver.gte(acc, curr)) {
            return acc;
        }
        return curr;
    });
    return latestVersion;
}
exports.getLatestVersion = getLatestVersion;
//# sourceMappingURL=data:application/json;base64,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