"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPrebuiltProviderVersionInformation = exports.getPrebuiltProviderVersions = exports.getAllPrebuiltProviderVersions = exports.getPrebuiltProviderRepositoryName = exports.getNpmPackageName = exports.getAllPrebuiltProviders = exports.resetFetchCache = void 0;
const https_proxy_agent_1 = require("https-proxy-agent");
const node_fetch_1 = __importDefault(require("node-fetch"));
const semver = __importStar(require("semver"));
const commons_1 = require("@cdktf/commons");
const dependency_manager_1 = require("./dependency-manager");
const version_constraints_1 = require("./version-constraints");
const proxy = process.env.http_proxy || process.env.HTTP_PROXY;
let agent;
if (proxy) {
    agent = new https_proxy_agent_1.HttpsProxyAgent(proxy);
}
// uses https://github.com/hashicorp/cdktf-repository-manager/blob/main/provider.json
const providersMapUrl = `https://www.cdk.tf/.well-known/prebuilt-providers.json`;
const fetchCache = new Map();
async function cachedFetch(url) {
    if (fetchCache.has(url)) {
        return fetchCache.get(url);
    }
    const responseBody = await fetchWrapped(url);
    fetchCache.set(url, responseBody);
    return responseBody;
}
// For testing purposes only
async function resetFetchCache() {
    fetchCache.clear();
}
exports.resetFetchCache = resetFetchCache;
async function fetchWrapped(url) {
    let response;
    try {
        response = await (0, node_fetch_1.default)(url, {
            agent,
            headers: { "User-Agent": "HashiCorp/cdktf-cli" },
        });
    }
    catch (e) {
        // Fetch only fails here because of connectivity issues
        commons_1.logger.error("Unable to request pre-built provider information: Network error, please check if you're connected to the internet and try again");
        throw new Error("Connection error");
    }
    if (!response.ok) {
        if (response.status >= 500) {
            throw new Error("Unexpected error while finding pre-built provider. Please try again.");
        }
        if (response.status === 404) {
            throw new Error(`Pre-built provider information not found`);
        }
        if (response.status >= 400) {
            const responseText = await response.text();
            // This means that we're sending a bad request. We should record this in sentry too.
            commons_1.logger.error(`Received ${response.status} response from ${url}: ${responseText}`);
            throw new Error("Unexpected error while finding pre-built provider. Please try again.");
        }
    }
    return response.json();
}
async function getAllPrebuiltProviders() {
    return cachedFetch(providersMapUrl);
}
exports.getAllPrebuiltProviders = getAllPrebuiltProviders;
async function getNpmPackageName(constraint) {
    const providers = await getAllPrebuiltProviders();
    const entry = Object.entries(providers).find(([, p]) => dependency_manager_1.ProviderConstraint.fromConfigEntry(p).source.toLowerCase() ===
        constraint.source.toLowerCase());
    if (!entry) {
        return undefined; // no pre-built provider found for this constraint
    }
    const name = entry[0];
    return `@cdktf/provider-${name}`;
}
exports.getNpmPackageName = getNpmPackageName;
async function getPrebuiltProviderRepositoryName(packageName) {
    var _a;
    const url = `https://registry.npmjs.org/${packageName}`;
    const result = await cachedFetch(url);
    const repositoryUrl = (_a = result === null || result === void 0 ? void 0 : result.repository) === null || _a === void 0 ? void 0 : _a.url;
    if (!repositoryUrl)
        return "";
    const repositoryRegex = /^git\+https:\/\/(github.com\/.*)\.git$/;
    const match = repositoryRegex.exec(repositoryUrl);
    if (!match)
        return "";
    return match[1];
}
exports.getPrebuiltProviderRepositoryName = getPrebuiltProviderRepositoryName;
async function getAllPrebuiltProviderVersions(packageName) {
    const url = `https://registry.npmjs.org/${packageName}`;
    const result = await cachedFetch(url);
    const versions = Object.entries(result.versions)
        .map(([version, packageJson]) => {
        var _a, _b;
        const provider = (_a = packageJson.cdktf) === null || _a === void 0 ? void 0 : _a.provider;
        if (!provider || !((_b = packageJson.peerDependencies) === null || _b === void 0 ? void 0 : _b.cdktf)) {
            commons_1.logger.trace(`skipping version ${version} of ${packageName} as it does not have a cdktf.provider or peerDependencies.cdktf in package.json`);
            return undefined;
        }
        return {
            packageVersion: version,
            providerVersion: provider.version,
            cdktfPeerDependencyConstraint: packageJson.peerDependencies.cdktf,
        };
    })
        .filter((v) => v !== undefined);
    // latest version first, sorted by packageVersion as that
    // one always increases while the providerVersion may not
    versions.sort((a, b) => {
        if (semver.gt(a.packageVersion, b.packageVersion)) {
            return -1;
        }
        if (semver.lt(a.packageVersion, b.packageVersion)) {
            return 1;
        }
        return 0;
    });
    return versions;
}
exports.getAllPrebuiltProviderVersions = getAllPrebuiltProviderVersions;
function cdktfVersionMatches(cdktfVersion, cdktfPeerDependencyConstraint) {
    return semver.satisfies(cdktfVersion, cdktfPeerDependencyConstraint);
}
async function getPrebuiltProviderVersions(constraint, cdktfVersion) {
    const providerName = await getNpmPackageName(constraint); // TODO: add lots of debug logs to this call
    // no pre-built provider exists
    if (!providerName) {
        return null;
    }
    const versions = await getAllPrebuiltProviderVersions(providerName);
    commons_1.logger.debug(`Found versions for ${providerName}: ${JSON.stringify(versions, null, 2)}`);
    // find first the version that matches the requested provider version and cdktf version
    const matchingVersions = versions.filter((v) => {
        if (!cdktfVersionMatches(cdktfVersion, v.cdktfPeerDependencyConstraint)) {
            return false; // skip if cdktf version does not match
        }
        if (constraint.version) {
            return (0, version_constraints_1.versionMatchesConstraint)(v.providerVersion, constraint.version);
        }
        return true; // if no version constraint is passed, return true on the first match
    });
    if (!matchingVersions.length) {
        return null;
    }
    const npmPackageVersions = matchingVersions
        .map((matchingVersion) => matchingVersion.packageVersion)
        .sort(semver.compare)
        .reverse();
    return npmPackageVersions;
}
exports.getPrebuiltProviderVersions = getPrebuiltProviderVersions;
async function getPrebuiltProviderVersionInformation(packageName, packageVersion) {
    // Go packages include an extra `vX.Y.Z`
    if (packageVersion.startsWith("v")) {
        packageVersion = packageVersion.slice(1);
    }
    const url = `https://registry.npmjs.org/${packageName}/${packageVersion}`;
    const result = await cachedFetch(url);
    let providerName = result.cdktf.provider.name;
    if (providerName) {
        providerName = providerName.replace("registry.terraform.io/", "");
        providerName = providerName.replace("hashicorp/", "");
    }
    return {
        packageName: result.name,
        packageVersion: result.version,
        providerName,
        providerVersion: result.cdktf.provider.version,
        cdktfVersion: result.peerDependencies["cdktf"],
    };
}
exports.getPrebuiltProviderVersionInformation = getPrebuiltProviderVersionInformation;
//# sourceMappingURL=data:application/json;base64,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