import { ProviderConstraint } from "./dependency-manager";
type ProvidersMap = {
    [name: string]: string;
};
export declare function resetFetchCache(): Promise<void>;
export declare function getAllPrebuiltProviders(): Promise<ProvidersMap>;
export declare function getNpmPackageName(constraint: ProviderConstraint): Promise<string | undefined>;
type PrebuiltProviderVersion = {
    packageVersion: string;
    providerVersion: string;
    cdktfPeerDependencyConstraint: string;
};
export declare function getPrebuiltProviderRepositoryName(packageName: string): Promise<string>;
export declare function getAllPrebuiltProviderVersions(packageName: string): Promise<PrebuiltProviderVersion[]>;
export declare function getPrebuiltProviderVersions(constraint: ProviderConstraint, cdktfVersion: string): Promise<string[] | null>;
export declare function getPrebuiltProviderVersionInformation(packageName: string, packageVersion: string): Promise<any>;
export {};
//# sourceMappingURL=prebuilt-providers.d.ts.map