import { Language } from "@cdktf/commons";
/**
 * manages installing, updating, and removing dependencies
 * in the package system used by the target language of a CDKTF
 * project
 */
export declare abstract class PackageManager {
    protected readonly workingDirectory: string;
    constructor(workingDirectory: string);
    static forLanguage(language: Language, workingDirectory: string): PackageManager;
    abstract addPackage(packageName: string, packageVersion?: string, silent?: boolean): Promise<void>;
    abstract isNpmVersionAvailable(packageName: string, packageVersion: string): Promise<boolean>;
    abstract listProviderPackages(): Promise<{
        name: string;
        version: string;
    }[]>;
}
//# sourceMappingURL=package-manager.d.ts.map