import { Language, TerraformDependencyConstraint } from "@cdktf/commons";
export declare const DEFAULT_HOSTNAME = "registry.terraform.io";
export declare const DEFAULT_NAMESPACE = "hashicorp";
export declare class ProviderConstraint {
    readonly version: string | undefined;
    /**
     * normalized source of the provider
     * e.g. "registry.terraform.io/hashicorp/aws"
     */
    readonly source: string;
    constructor(source: string, version: string | undefined);
    static fromConfigEntry(provider: string | TerraformDependencyConstraint): ProviderConstraint;
    isFromTerraformRegistry(): boolean;
    /**
     * the namespace of the provider
     * e.g. "hashicorp" or "kreuzwerker"
     */
    get namespace(): string;
    /**
     * the name of the provider
     * e.g. "aws"
     */
    get name(): string;
    /**
     * the hostname of the provider
     * e.g. "registry.terraform.io"
     */
    get hostname(): string;
    /**
     * returns a simplified provider name, dropping namespace and hostname
     * if they match the defaults
     */
    get simplifiedName(): string;
    /**
     * checks if the version constraint matches the given version
     * @param version an actual version (e.g. "4.12.1")
     * @returns true if the version is compatible with the constraint
     */
    matchesVersion(version: string): boolean;
    toString(): string;
}
/**
 * manages dependencies of a CDKTF project (e.g. terraform providers)
 */
export declare class DependencyManager {
    private readonly targetLanguage;
    private cdktfVersion;
    private readonly projectDirectory;
    private packageManager;
    constructor(targetLanguage: Language, cdktfVersion: string, projectDirectory: string);
    addProvider(constraint: ProviderConstraint): Promise<{
        addedLocalProvider: boolean;
    }>;
    upgradeProvider(constraint: ProviderConstraint): Promise<{
        addedLocalProvider: boolean;
    }>;
    getCurrentlyInstalledVersion(constraint: ProviderConstraint): Promise<string | undefined>;
    upgradePrebuiltProvider(constraint: ProviderConstraint, currentVersion: string): Promise<void>;
    hasPrebuiltProvider(constraint: ProviderConstraint): Promise<boolean>;
    private tryGetPackageName;
    private getPackageName;
    getMatchingProviderVersion(constraint: ProviderConstraint): Promise<string>;
    addPrebuiltProvider(constraint: ProviderConstraint, silent?: boolean): Promise<void>;
    private getLanguageSpecificPackageVersion;
    addLocalProvider(constraint: ProviderConstraint): Promise<void>;
    /**
     * Converts an NPM package name of a pre-built provider package to the name in the target language
     */
    private convertPackageName;
    /**
     * Converts an package name of a pre-built provider package in target language to the name in npm
     * Inverse of: `convertPackageName`
     */
    private convertFromPackageNameToNpm;
    allProviders(): Promise<{
        local: {
            providerName: string;
            providerConstraint: string | undefined;
            providerVersion: string | null;
        }[];
        prebuilt: any[];
    }>;
}
//# sourceMappingURL=dependency-manager.d.ts.map