"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdktfConfigManager = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const cdktf_config_1 = require("../cdktf-config");
const dependency_manager_1 = require("./dependency-manager");
/**
 * facilitates adding provider dependencies to cdktf.json
 */
class CdktfConfigManager {
    constructor() {
        this.config = cdktf_config_1.CdktfConfig.read();
    }
    async hasProvider(constraint) {
        return this.config.terraformProviders.some((provider) => dependency_manager_1.ProviderConstraint.fromConfigEntry(provider).source ===
            constraint.source);
    }
    async setProvider(constraint) {
        // excluding the constraint to be added (if it already existed)
        const currentProviders = this.config.terraformProviders.filter((provider) => dependency_manager_1.ProviderConstraint.fromConfigEntry(provider).source !==
            constraint.source);
        const simplifiedSource = constraint.source.replace("registry.terraform.io/", "");
        const provider = simplifiedSource + (constraint.version ? `@${constraint.version}` : "");
        currentProviders.push(provider);
        this.config.writeTerraformProviders(currentProviders);
    }
    async addProvider(constraint) {
        await this.setProvider(constraint);
    }
    async updateProvider(constraint) {
        await this.setProvider(constraint);
    }
}
exports.CdktfConfigManager = CdktfConfigManager;
//# sourceMappingURL=data:application/json;base64,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