"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertConfigurationFile = void 0;
const hcl2cdk = __importStar(require("@cdktf/hcl2cdk"));
const cdktf_config_1 = require("./cdktf-config");
const provider_generator_1 = require("@cdktf/provider-generator");
const provider_schema_1 = require("@cdktf/provider-schema");
const commons_1 = require("@cdktf/commons");
async function convertConfigurationFile(configuration, stackWorkingDirectory) {
    const cfg = cdktf_config_1.CdktfConfig.read(stackWorkingDirectory);
    const targets = cfg.terraformProviders.map((constraint) => commons_1.ConstructsMakerProviderTarget.from(new provider_generator_1.TerraformProviderConstraint(constraint), commons_1.LANGUAGES[0]));
    const { providerSchema } = await (0, provider_schema_1.readSchema)(targets);
    if (!providerSchema) {
        throw commons_1.Errors.Internal("Could not fetch provider schema");
    }
    const { all } = await hcl2cdk.convert(configuration, {
        providerSchema,
        language: cfg.language,
        codeContainer: "constructs.Construct",
    });
    return all;
}
exports.convertConfigurationFile = convertConfigurationFile;
//# sourceMappingURL=data:application/json;base64,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