import { SynthesizedStack } from "./synth-stack";
import { Terraform } from "./models/terraform";
import { NestedTerraformOutputs } from "./output";
export type StackUpdate = {
    type: "planning";
    stackName: string;
} | {
    type: "planned";
    stackName: string;
} | {
    type: "deploying";
    stackName: string;
} | {
    type: "deploy update";
    stackName: string;
    deployOutput: string;
} | {
    type: "deployed";
    stackName: string;
    outputsByConstructId: NestedTerraformOutputs;
    outputs: Record<string, any>;
} | {
    type: "destroying";
    stackName: string;
} | {
    type: "destroy update";
    stackName: string;
    destroyOutput: string;
} | {
    type: "destroyed";
    stackName: string;
} | {
    type: "outputs fetched";
    stackName: string;
    outputsByConstructId: NestedTerraformOutputs;
    outputs: Record<string, any>;
} | {
    type: "errored";
    stackName: string;
    error: string;
} | {
    type: "dismissed";
    stackName: string;
} | {
    type: "import with configuration detected";
    stackName: string;
    configuration: string;
} | {
    type: "import with configuration converted";
    stackName: string;
    configuration: string;
};
export type StackUserInputUpdate = StackApprovalUpdate | StackSentinelOverrideUpdate;
export type StackApprovalUpdate = {
    type: "waiting for stack approval";
    stackName: string;
    approve: () => void;
    reject: () => void;
};
export type StackSentinelOverrideUpdate = {
    type: "waiting for stack sentinel override";
    stackName: string;
    override: () => void;
    reject: () => void;
};
export type ExternalStackApprovalUpdate = {
    type: "external stack approval reply";
    stackName: string;
    approved: boolean;
};
export type ExternalStackSentinelOverrideUpdate = {
    type: "external stack sentinel override reply";
    stackName: string;
    overridden: boolean;
};
type CdktfStackOptions = {
    stack: SynthesizedStack;
    onUpdate: (update: StackUpdate | StackApprovalUpdate | ExternalStackApprovalUpdate | StackSentinelOverrideUpdate | ExternalStackSentinelOverrideUpdate) => void;
    onLog?: (log: {
        message: string;
        isError: boolean;
    }) => void;
    autoApprove?: boolean;
    migrateState?: boolean;
    abortSignal: AbortSignal;
};
type CdktfStackStates = StackUpdate["type"] | StackApprovalUpdate["type"] | StackSentinelOverrideUpdate["type"] | ExternalStackApprovalUpdate["type"] | ExternalStackSentinelOverrideUpdate["type"] | "idle" | "done";
export declare class CdktfStack {
    options: CdktfStackOptions;
    stack: SynthesizedStack;
    outputs?: Record<string, any>;
    outputsByConstructId?: NestedTerraformOutputs;
    stopped: boolean;
    currentWorkPromise: Promise<void> | undefined;
    readonly currentState: CdktfStackStates;
    error?: string;
    private readonly parsedContent;
    constructor(options: CdktfStackOptions);
    get isPending(): boolean;
    get isDone(): boolean;
    get isRunning(): boolean;
    private updateState;
    private createTerraformLogHandler;
    private terraformClient;
    initalizeTerraform(noColor?: boolean, skipProviderLock?: boolean, migrateState?: boolean): Promise<Terraform>;
    private requiredProviders;
    private checkNeedsLockfileUpdate;
    private checkNeedsUpgrade;
    private run;
    diff({ refreshOnly, terraformParallelism, vars, varFiles, noColor, }: {
        refreshOnly?: boolean;
        terraformParallelism?: number;
        vars?: string[];
        varFiles?: string[];
        noColor?: boolean;
    }): Promise<void>;
    deploy(opts: {
        refreshOnly?: boolean;
        terraformParallelism?: number;
        noColor?: boolean;
        vars?: string[];
        varFiles?: string[];
    }): Promise<void>;
    destroy(opts: {
        terraformParallelism?: number;
        vars?: string[];
        varFiles?: string[];
        noColor?: boolean;
    }): Promise<void>;
    fetchOutputs(): Promise<Record<string, any> | undefined>;
    stop(): Promise<void>;
}
export {};
//# sourceMappingURL=cdktf-stack.d.ts.map