import { SynthesizedStack, SynthOrigin } from "./synth-stack";
import { CdktfStack, StackUpdate } from "./cdktf-stack";
import { NestedTerraformOutputs } from "./output";
type MultiStackApprovalUpdate = {
    type: "waiting for approval";
    stackName: string;
    approve: () => void;
    dismiss: () => void;
    stop: () => void;
};
type MultiStackSentinelOverrideUpdate = {
    type: "waiting for sentinel override";
    stackName: string;
    override: () => void;
    reject: () => void;
};
export type MultiStackUpdate = MultiStackApprovalUpdate | MultiStackSentinelOverrideUpdate;
export type ProjectUpdate = {
    type: "synthesizing";
} | {
    type: "synthesized";
    stacks: SynthesizedStack[];
    errorMessage?: string;
} | StackUpdate | MultiStackUpdate;
export type SingleStackOptions = {
    stackName?: string;
};
export type MultipleStackOptions = {
    stackNames?: string[];
};
export type SkipSynthOptions = {
    skipSynth?: boolean;
};
export type SkipProviderLockOptions = {
    skipProviderLock?: boolean;
};
export type FetchOutputOptions = SkipSynthOptions & SkipProviderLockOptions & MultipleStackOptions;
export type AutoApproveOptions = {
    autoApprove?: boolean;
};
export type DiffOptions = SingleStackOptions & SkipProviderLockOptions & SkipSynthOptions & {
    refreshOnly?: boolean;
    terraformParallelism?: number;
    vars?: string[];
    varFiles?: string[];
    noColor?: boolean;
    migrateState?: boolean;
};
export type MutationOptions = MultipleStackOptions & SkipProviderLockOptions & SkipSynthOptions & AutoApproveOptions & {
    refreshOnly?: boolean;
    ignoreMissingStackDependencies?: boolean;
    parallelism?: number;
    terraformParallelism?: number;
    vars?: string[];
    varFiles?: string[];
    noColor?: boolean;
    migrateState?: boolean;
};
export type LogMessage = {
    stackName: string;
    messageWithConstructPath?: string;
    message: string;
};
type Buffered<T, V> = {
    cb: (item: T) => void;
    value: T;
    type: V;
};
export declare function isWaitingForUserInputUpdate(update: ProjectUpdate | StackUpdate): boolean;
export type ProjectEvent = Buffered<ProjectUpdate, "projectUpdate"> | Buffered<LogMessage, "logMessage">;
export type CdktfProjectOptions = {
    synthCommand: string;
    outDir: string;
    onUpdate: (update: ProjectUpdate) => void;
    onLog?: (log: LogMessage) => void;
    workingDirectory?: string;
    synthOrigin?: SynthOrigin;
    hcl?: boolean;
};
export declare class CdktfProject {
    stacks?: SynthesizedStack[];
    hardAbort: () => void;
    private synthCommand;
    private outDir;
    private workingDirectory;
    private onUpdate;
    private onLog?;
    private abortSignal;
    private synthOrigin?;
    private hcl?;
    stacksToRun: CdktfStack[];
    private stopAllStacksThatCanNotRunWithout;
    private ioHandler;
    constructor({ synthCommand, outDir, onUpdate, onLog, workingDirectory, synthOrigin, hcl, }: CdktfProjectOptions);
    private stopAllStacks;
    private handleUserUpdate;
    private handleUserInputProcess;
    getStackExecutor(stack: SynthesizedStack, opts?: AutoApproveOptions): CdktfStack;
    get outputsByConstructId(): NestedTerraformOutputs;
    synth(noColor?: boolean): Promise<SynthesizedStack[]>;
    readSynthesizedStacks(): Promise<SynthesizedStack[]>;
    diff(opts?: DiffOptions): Promise<void>;
    private execute;
    deploy(opts?: MutationOptions): Promise<void>;
    destroy(opts?: MutationOptions): Promise<void>;
    projectTelemetry(command: string, payload: any): Promise<void>;
    fetchOutputs(opts: FetchOutputOptions): Promise<NestedTerraformOutputs>;
    private initializeStacksToRunInSerial;
}
export {};
//# sourceMappingURL=cdktf-project.d.ts.map