/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { ProjectEvent, LogMessage } from "./cdktf-project";
/**
 * This class is used to buffer events while the user is being asked for input. It is solely consumed by the CdktfProject class,
 * and is mostly created as a separation of concerns to keep the CdktfProject class as clean as possible.
 */
export declare class CdktfProjectIOHandler {
    private waitingForUserInput;
    private eventBuffer;
    awaitUserInput(): void;
    filterUserInputEventsFromBuffer(): void;
    resumeAfterUserInput(stackName: string): void;
    isWaitingForUserInput(): boolean;
    pushEvent(event: ProjectEvent): void;
    bufferWhileAwaitingUserInput(cb?: (msg: LogMessage) => void): ((msg: LogMessage) => void) | undefined;
}
//# sourceMappingURL=cdktf-project-io-handler.d.ts.map