"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdktfConfig = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const commons_1 = require("@cdktf/commons");
const path_1 = __importDefault(require("path"));
const commons_2 = require("@cdktf/commons");
function findFileAboveCwd(file, rootPath = process.cwd()) {
    const fullPath = path_1.default.resolve(rootPath, file);
    if (fs.existsSync(fullPath)) {
        return fullPath;
    }
    const parentDir = path_1.default.resolve(rootPath, "..");
    if (fs.existsSync(parentDir) && parentDir !== rootPath) {
        return findFileAboveCwd(file, parentDir);
    }
    return null;
}
// TODO: move this to @cdktf/commons
// tracked here https://github.com/hashicorp/terraform-cdk/issues/1814
class CdktfConfig {
    constructor(cdktfConfigPath) {
        this.cdktfConfigPath = cdktfConfigPath;
    }
    readCdktfConfig() {
        const cdktfConfig = require(this.cdktfConfigPath);
        if (typeof cdktfConfig !== "object" || cdktfConfig === null) {
            throw commons_1.Errors.External("cdktf.json is malformed. The root must be a JSON object."); // TODO: define a schema and validate against it
        }
        return cdktfConfig;
    }
    writeCdktfConfig(cdktfConfig) {
        const cdktfConfigString = JSON.stringify(cdktfConfig, null, 2);
        fs.writeFileSync(this.cdktfConfigPath, cdktfConfigString);
    }
    getProperty(property) {
        const cdktfConfig = this.readCdktfConfig();
        return cdktfConfig[property] || commons_1.CONFIG_DEFAULTS[property];
    }
    get language() {
        const rawLanguage = this.getProperty("language");
        const language = Object.values(commons_1.Language).find((value) => value === rawLanguage);
        if (!language)
            throw commons_1.Errors.Usage(`${rawLanguage} is not a valid language. It must be one of ${Object.values(commons_1.Language)}`);
        return language;
    }
    get codeMakerOutput() {
        return this.getProperty("codeMakerOutput");
    }
    get terraformProviders() {
        const providers = this.getProperty("terraformProviders");
        if (!Array.isArray(providers))
            return [];
        return providers;
    }
    get terraformModules() {
        const modules = this.getProperty("terraformModules");
        if (!Array.isArray(modules))
            return [];
        return modules;
    }
    writeTerraformProviders(providers) {
        const cdktfConfig = this.readCdktfConfig();
        cdktfConfig.terraformProviders = providers;
        this.writeCdktfConfig(cdktfConfig);
    }
    get projectDirectory() {
        return path_1.default.dirname(this.cdktfConfigPath);
    }
    static read(path = process.cwd()) {
        const cdktfConfigPath = findFileAboveCwd("cdktf.json", path);
        if (!cdktfConfigPath) {
            throw commons_1.Errors.External("Could not find cdktf.json. Make sure there is a cdktf.json file in the current directory or one of its parents.");
        }
        commons_2.logger.trace(`cdktf.json found at ${cdktfConfigPath}`);
        return new CdktfConfig(cdktfConfigPath);
    }
}
exports.CdktfConfig = CdktfConfig;
//# sourceMappingURL=data:application/json;base64,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