"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
var esbuild = require("esbuild");
var fs = require("fs-extra");
var enableWatch = process.argv.find(function (arg) { return arg === "--watch"; }) === "--watch";
// Taken from https://github.com/evanw/esbuild/issues/1051#issuecomment-806325487 to deal with `fsevents`
var nativeNodeModulesPlugin = {
    name: "native-node-modules",
    setup: function (build) {
        // If a ".node" file is imported within a module in the "file" namespace, resolve
        // it to an absolute path and put it into the "node-file" virtual namespace.
        build.onResolve({ filter: /\.node$/, namespace: "file" }, function (args) { return ({
            path: require.resolve(args.path, { paths: [args.resolveDir] }),
            namespace: "node-file",
        }); });
        // Files in the "node-file" virtual namespace call "require()" on the
        // path from esbuild of the ".node" file in the output directory.
        build.onLoad({ filter: /.*/, namespace: "node-file" }, function (args) { return ({
            contents: "\n        import path from ".concat(JSON.stringify(args.path), "\n        try { module.exports = require(path) }\n        catch {}\n      "),
        }); });
        // If a ".node" file is imported within a module in the "node-file" namespace, put
        // it in the "file" namespace where esbuild's default loading behavior will handle
        // it. It is already an absolute path since we resolved it to one above.
        build.onResolve({ filter: /\.node$/, namespace: "node-file" }, function (args) { return ({
            path: args.path,
            namespace: "file",
        }); });
        // Tell esbuild's default loading behavior to use the "file" loader for
        // these ".node" files.
        var opts = build.initialOptions;
        opts.loader = opts.loader || {};
        opts.loader[".node"] = "file";
    },
};
var config = {
    entryPoints: ["src/bin/cdktf.ts", "src/bin/cmds/handlers.ts"],
    outbase: "src",
    bundle: true,
    outdir: "./bundle",
    format: "cjs",
    target: "node14",
    minify: enableWatch ? false : true,
    sourcemap: enableWatch ? false : true,
    platform: "node",
    external: [
        "jsii",
        "jsii-pacmak",
        "@cdktf/hcl2json",
        "@cdktf/hcl-tools",
        "yargs",
        "cdktf",
        "@cdktf/hcl2cdk",
        "constructs",
        "yoga-layout-prebuilt",
        "@cdktf/node-pty-prebuilt-multiarch",
    ],
    plugins: [
        nativeNodeModulesPlugin,
        {
            name: "rebuild-log",
            setup: function (_a) {
                var onStart = _a.onStart, onEnd = _a.onEnd;
                var t;
                onStart(function () {
                    t = Date.now();
                });
                onEnd(function () {
                    console.log("build finished in", Date.now() - t, "ms");
                });
            },
        },
    ],
    define: {
        "process.env.SENTRY_DSN": JSON.stringify(process.env.SENTRY_DSN || ""),
    },
    tsconfig: "tsconfig.json",
};
(function () { return __awaiter(void 0, void 0, void 0, function () {
    var ctx;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                console.log("Building…");
                return [4 /*yield*/, esbuild.build(config)];
            case 1:
                _a.sent();
                fs.copySync("src/bin/cdktf", "./bundle/bin/cdktf");
                fs.copySync("../@cdktf/cli-core/templates", "./bundle/templates");
                if (!enableWatch) return [3 /*break*/, 4];
                return [4 /*yield*/, esbuild.context(config)];
            case 2:
                ctx = _a.sent();
                console.log("Watching…");
                return [4 /*yield*/, ctx.watch()];
            case 3:
                _a.sent();
                _a.label = 4;
            case 4: return [2 /*return*/];
        }
    });
}); })();
